<?php

##  user allowed branches 
##############################  

function branchInfos($branchesActivate, $smarty) {
    if ($branchesActivate == 1) {
        $showBrancheSelect = 0;
        $selectedBranch = '';
        $showStart = 1;
        $showAll = 1;

        $user = R::getRow('SELECT related_branches FROM awusers 
                    WHERE user_id = ? LIMIT 1', [$_SESSION['user_id']]);

        if ($user['related_branches'] == 0 && $user['related_branches'] != '' && $user['related_branches'] != null) {
            $branches = R::findAll('branches');
            $showBrancheSelect = 1;
            $showStart = 0;
        } else {
            $related_branches = array();
            $relBranches = explode(',', $user['related_branches']);
            foreach ($relBranches as $value) {
                $value = trim($value);
                array_push($related_branches, $value);
            }

            if ($related_branches[0] > 0) {
                if (count($related_branches) == 1) {
                    $selectedBranch = $related_branches[0];
                } elseif (count($related_branches) > 1) {
                    $showBrancheSelect = 1;
                }
                $showStart = 0;
                $showAll = 0;
                $branches = R::findAll('branches', '  id  in ( ' . $user['related_branches'] . ' ) ');
            } else {
                $showBrancheSelect = 1;
                $showAll = 0;
            }
        }

        $smarty->assign('showStart', $showStart);
        $smarty->assign('showAll', $showAll);
        $smarty->assign('branches', $branches);
        $smarty->assign('selectedBranch', $selectedBranch);
        $smarty->assign('showBrancheSelect', $showBrancheSelect);
    }
}

function branchInfosVisit($branchesActivate, $smarty) {
    if ($branchesActivate == 1) {
        $showBrancheSelect = 0;
        $selectedBranch = '';

        $user = R::getRow('SELECT related_branches FROM awusers 
                    WHERE user_id = ? LIMIT 1', [$_SESSION['user_id']]);

        if ($user['related_branches'] == 0 && $user['related_branches'] != '' && $user['related_branches'] != null) {
            $branches = R::findAll('branches');
            $showBrancheSelect = 1;
        } else {
            $related_branches = array();
            $relBranches = explode(',', $user['related_branches']);
            foreach ($relBranches as $value) {
                $value = trim($value);
                array_push($related_branches, $value);
            }

            if ($related_branches[0] > 0) {
                if (count($related_branches) == 1) {
                    $selectedBranch = $related_branches[0];
                } elseif (count($related_branches) > 1) {
                    $showBrancheSelect = 1;
                }
                $branches = R::findAll('branches', '  id  in ( ' . $user['related_branches'] . ' ) ');
            } else {
                $branches = R::findAll('branches');
                $showBrancheSelect = 1;
            }
        }

        $allBranches = R::findAll('branches');
        $smarty->assign('allBranches', $allBranches);
        $smarty->assign('branches', $branches);
        $smarty->assign('selectedBranch', $selectedBranch);
        $smarty->assign('showBrancheSelect', $showBrancheSelect);
    }
}

function showBranchCol($branchesActivate) {
    $show = 0;
    if ($branchesActivate == 1) {
        $user = R::getRow('SELECT related_branches FROM awusers 
                    WHERE user_id = ? LIMIT 1', [$_SESSION['user_id']]);

        if ($user['related_branches'] == 0 && $user['related_branches'] != '' && $user['related_branches'] != null) {
            $show = 1;
        } else {
            $related_branches = array();
            $relBranches = explode(',', $user['related_branches']);
            foreach ($relBranches as $value) {
                $value = trim($value);
                array_push($related_branches, $value);
            }

            if ($related_branches[0] > 0 && count($related_branches) > 1) {
                $show = 1;
            }
        }
    }
    return $show;
}


function getPatientInfoAll($patient, $for_husband, $child , $currentDate) {
    $programesetting = R::findOne('programesetting');
    $wifetypes = R::load('wifetypes', $patient->wiftypeid);
    $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);
    $result = array();
    $title = '';

    if ($programesetting->system_lang == 2) {
        $date = $patient['dateofbirth'];
        $name = $patient['wifename'];
        $sex = $patient['gender'];
        $title = $wifetypes->title;
    } else {
        $age = '';
        $ageUnit = 0;

        if ($for_husband == 1) {
            $date = $patient['husbanddateofbirth'];
            $name = $patient['husdandname'];
            $sex = 1;
            $title = $husbandtypes->title;
        } else if ($for_husband == 2) {
            $child = R::load('patients_childs', $child);
            $sex = $child->gender;
            $date = $child->birth_date;

            if (is_null($child->child_name) || $child->child_name == '') {
                if ($child->gender == 1) {
                    $name = 'الطفل / ' . $patient['wifename'];
                } else {
                    $name = 'الطفلة / ' . $patient['wifename'];
                }
            } else {
                $name = $child->child_name . '  /  ' . $patient['wifename'];
            }
        } else {
            $date = $patient['dateofbirth'];
            $name = $patient['wifename'];
            $sex = 0;
            $title = $wifetypes->title;
        }
    }


    if ($sex == 1) {
        $gender = 'Male';
        $gen = 'M';
    } else {
        $gender = 'Female';
        $gen = 'F';
    }


    if ($date != '0000-00-00' && $date != '' && $date != Null) {
        $dateN = new DateTime($date);
        $today1 = new DateTime($currentDate);
        $interval = $today1->diff($dateN);
    }

    if ($interval->y > 0) {
        $ageNo = $interval->y;
        $age = $interval->y . ' Years';
        $ageMin = $interval->y . 'Y';
        $ageUnit = 1;
    } elseif ($interval->m > 0) {
        $ageNo = $interval->m;
        $age = $interval->m . ' Months';
        $ageMin = $interval->m . 'M';
        $ageUnit = 2;
    } elseif ($interval->d >= 0) {
        $ageNo = 1 + $interval->d;
        $age = 1 + $interval->d . ' Days';
        $ageMin = $interval->d . 'D';
        $ageUnit = 3;
    }

    $result['name'] = $name;
    $result['gender'] = $gender;
    $result['gen'] = $gen;
    $result['sex'] = $sex;
    $result['age'] = $age;
    $result['ageMin'] = $ageMin;
    $result['ageNo'] = $ageNo;
    $result['ageUnit'] = $ageUnit;
    $result['title'] = $title;
    return $result;
}




