<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'decleration';
        $this->shcontrollname = 'decleration';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'decleration'; //controller name or tab name
        $active[1] = 'decleration'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'declerationshow';
                break;
            case 'show':$active[2] = 'declerationshow';
                break;
            default :$active[2] = 'declerationshow';
                break;
        }
        $this->active = $active;



//here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

//find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);

//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $py_all_doc = R::getAll('select * from awusers where role_id in (4,8,11)');
        $this->smarty->assign('py_all_doc', $py_all_doc);

        $this->smarty->display('decleration/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

//vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');

        $doctor = filter_input(INPUT_POST, "namedoctor");
        $doctor_id = filter_input(INPUT_POST, "doctor_id");
        $date = filter_input(INPUT_POST, 'namedate');

        $husband = filter_input(INPUT_POST, 'husband');
        $wife = filter_input(INPUT_POST, "wife");
        $reception = filter_input(INPUT_POST, 'reception');


        $this->smarty->assign('patientId', $patientid);

//here the add
        $decleration = R::dispense('decleration');

        $decleration->title = $title;
        $decleration->content = $content;
        $decleration->doctor_name = $doctor;
        $decleration->doctor_id = $doctor_id;
        $decleration->date = $date;

        $decleration->husband = $husband;
        $decleration->wife = $wife;
        $decleration->reception = $reception;


        try {
            $id = R::store($decleration);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
//load all declerations here
        $showElems = R::getAll('SELECT * FROM decleration order by id asc');
        $this->smarty->assign('showElems', $showElems);

        $this->smarty->assign('patientId', $patientid);

//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('decleration/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

//get id for item
        $id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");

//load all here
        $editElement = R::load('decleration', $id);
        $this->smarty->assign('editElement', $editElement);
        $this->smarty->assign('patientId', $patientid);
//load all users
        $py_all_doc = R::getAll('select * from awusers where role_id in (4,8,11)');
        $this->smarty->assign('py_all_doc', $py_all_doc);


//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('decleration/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

//vars here
        $id = filter_input(INPUT_POST, 'editElement_id');

        $title = filter_input(INPUT_POST, 'title');

        $content = filter_input(INPUT_POST, 'content');

        $doctor = filter_input(INPUT_POST, "namedoctor");
        $doctor_id = filter_input(INPUT_POST, "doctor_id");

        $date = filter_input(INPUT_POST, 'namedate');
        $husband = filter_input(INPUT_POST, 'husband');


        $wife = filter_input(INPUT_POST, "wife");

        $reception = filter_input(INPUT_POST, 'reception');

        $reception = filter_input(INPUT_POST, "reception");



        $patientid = filter_input(INPUT_GET, "patientid");

        $this->smarty->assign('patientId', $patientid);


//here the update
        $decleration = R::load('decleration', $id);


        $decleration->title = $title;
        $decleration->content = $content;
        $decleration->doctor_id = $doctor_id;
        $decleration->date = $date;
        $decleration->husband = $husband;

        $decleration->wife = $wife;

        $decleration->reception = $reception;
        $decleration->wife = $wife;
        $decleration->doctor_name = $doctor;


        try {
            R::store($decleration);

            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        $del = R::load("decleration", $id);
        try {
            R::trash($del);
            echo 1;
        } catch (Exception $e) {
            
        }
    }

// at the end of class call
    public function __destruct() {
//colse connection
        R::close();
    }

}
