<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

use RedBeanPHP\RedException;

require_once("imp/_imp.php");

/**
 * @class calendar
 */
class Controllers
{
    //public vars
    public $smarty;
    public $host_url;
    public $controlName;
    public $active;

    /**
     * @throws RedException
     */
    public function __construct()
    {
        require_once('../public/aw_config.php');
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->host_url = $hosturl;

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $action = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $action);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $this->controlName = 'endoscopy_template';
        $shcontrollname = 'Endoscopy Template';
        $this->smarty->assign('controllname', $this->controlName);
        $this->smarty->assign('shcontrollname', $shcontrollname);

        $active[0] = 'endoscopy';
        $active[1] = $this->controlName;
        $active[2] = 'show';
        $this->active = $active;

        R::ext('xdispense', static function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("../../_library/plugins/classupload/uploadfunctions.php");

        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    public function index()
    {
        $this->authChecking();

        $templateData = R::findOne('endoscopy_template', 'id = 1');
        $this->smarty->assign('template_data', $templateData);

        $this->smartyHtml('endoscopy/template/index.tpl');
    }

    public function update()
    {
        $this->authChecking();

        $id = filter_input(INPUT_POST, 'id');

        $headerPrint = uploadupdate('header_print', 'header_print_save', False, 0, 0, 'endoscopy_template');
        $footerPrint = uploadupdate('footer_print', 'footer_print_save', False, 0, 0, 'endoscopy_template');

        $bean = R::load('endoscopy_template', $id);
        $bean->indication = filter_input(INPUT_POST, 'indication');
        $bean->anesthesia = filter_input(INPUT_POST, 'anesthesia');
        $bean->procedure = filter_input(INPUT_POST, 'procedure');
        $bean->esophagus = filter_input(INPUT_POST, 'esophagus');
        $bean->cardio_esophageal_junction= filter_input(INPUT_POST, 'cardio_esophageal_junction');
        $bean->stomach = filter_input(INPUT_POST, 'stomach');
        $bean->pylorus = filter_input(INPUT_POST, 'pylorus');
        $bean->duodenum = filter_input(INPUT_POST, 'duodenum');
        $bean->conclusion = filter_input(INPUT_POST, 'conclusion');
        $bean->header_print = $headerPrint;
        $bean->footer_print = $footerPrint;
        $bean->updated_at = date('Y-m-d H:i:s');

        try {
            R::store($bean);
            header('Location:' . $this->host_url . '/controllers/' . $this->controlName . '.php?ac=index');
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/controllers/error?ac=notupdate&id=' . $this->controlName);
        }
    }

    public function __destruct()
    {
        R::close();
    }

    /**
     * @return void
     */
    protected function smartyHtml($file_path)
    {
        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display($file_path);
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    /**
     * @return void
     */
    protected function authChecking($login_check = true, $permission_check = true)
    {
        !$login_check ?: autho::checkautho($this->host_url);
        !$permission_check ?: autho::checkauthoize($this->controlName, $this->host_url, $_SESSION['role_id']);
    }

}
