<?php

function getReferredDrName($referred_dr_id, $refer_doctor_tb) {

    if ($referred_dr_id > 0) {
        switch ($refer_doctor_tb) {
            case 1:
                $refer = R::getRow('select name from awusers where user_id = ?', [$referred_dr_id]);
                $ref_dr = $refer['name'];
                break;

            default:
                $refer = R::load('refer', $referred_dr_id);
                $ref_dr = $refer->name;
                break;
        }
    } else {
        $ref_dr = 'لا يوجد';
    }
    return $ref_dr;
}

function getEmbDrName($dr_id, $dr_tb) {
    if ($dr_id > 0) {
        switch ($dr_tb) {
            case 1:
                $dr = R::load('embryologist', $dr_id);
                $dr_name = $dr->name;
                break;

            default:
                $dr = R::getRow('select name from awusers where user_id = ?', [$dr_id]);
                $dr_name = $dr['name'];
                break;
        }
    } else {
        $dr_name = 'لا يوجد';
    }
    return $dr_name;
}

function getVisitRfc($visitId) {

    if ($visitId > 0) {
        $visit = R::load('visits', $visitId);
        switch ($visit->rfc) {
            case 1:
                $visit_rfc = ' Yes ';
                break;

            case 2:
                $visit_rfc = ' No ';
                break;

            default:
                $visit_rfc = ' ';
                break;
        }
    } else {
        $visit_rfc = ' ';
    }
    return $visit_rfc;
}

function checkEmbVisit($embryoslab_id) {
    $em_lab = R::load('embryoslab', $embryoslab_id);
    if (!($em_lab->visit_id > 0 )) {
        $visit = lastVisitByEmbryoDetection($em_lab->patient_id);
        if (count($visit) > 0) {
            $em_lab->visit_id = $visit->id;
            $em_lab->date = $visit->visitdate;
            R::store($em_lab);
        }
    }
}

function lastVisitByEmbryoDetection($patientId) {
    $detectTxt = '';
    $detections = R::findAll('detections', 'del = 0 and for_embryo = 1 ');
    $i = 0;
    foreach ($detections as $detection) {
        if ($i > 0) {
            $detectTxt .= ', ';
        }
        $detectTxt .= $detection->id;
        $i++;
    }

    if ($detectTxt != '') {
        $visit = R::findOne('visits', 'patientid = ? and detectionid in ( ' . $detectTxt . ' )
                                 and visitdate <= ? and deleted != 1 order by visitdate desc '
                        , [$patientId, date('Y-m-d')]);
    }

    return $visit;
}

function lastVisitByDept($deptId, $patientid) {
    $awrole = R::load('awrole', $deptId);
    if ($awrole->custom_detections != null && !empty($awrole->custom_detections &&
                    $awrole->custom_detections != "")) {
        //  R::debug(true, 2);
        $visit = R::findOne('visits', 'patientid = ? and detectionid in ( ' . $awrole->custom_detections . ' )
    and visitdate <= ? and deleted != 1 order by visitdate desc '
                        , [$patientid, date('Y-m-d')]);
        //   R::debug(false);
    }

    return $visit;
}

function calcPatAge($birthDate, $visitDate) {
    $visitDate = new DateTime($visitDate);
    $age = 0;

    $birthDate = new DateTime($birthDate);

    if ($birthDate == '0000-00-00' || is_null($birthDate)) {
        $age = 0;
    } else {
        ## calculate wife age
        $interva2 = $visitDate->diff($birthDate);
        $age = $interva2->y . 'Y, ' . $interva2->m . 'M, ' . $interva2->d . 'D ';
    }
    return$age;
}

function calcPatAgeYear($birthDate, $visitDate) {
    $visitDate = new DateTime($visitDate);
    $age = 0;

    $birthDate = new DateTime($birthDate);

    if ($birthDate == '0000-00-00' || is_null($birthDate)) {
        $age = 0;
    } else {
        ## calculate wife age
        $interva2 = $visitDate->diff($birthDate);
        $age = $interva2->y;
    }
    return$age;
}
