<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        $this->controllname = 'laparoscopic';
        $this->shcontrollname = 'Laparoscopic';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = 'laparoscopic';
        $active[1] = 'laparoscopic';
        switch ($acty) {
            case '':
                $active[2] = 'laparoscopicadd';
                break;
            default :
                $active[2] = 'laparoscopicshow';
                break;
        }
        $this->active = $active;

        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('laparoscopic/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $row = R::dispense('laparoscopic');
        $row->template_name = filter_input(INPUT_POST, 'template_name');
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->uterus = filter_input(INPUT_POST, 'uterus');
        $row->uterus_procedures = filter_input(INPUT_POST, 'uterus_procedures');
        $row->right_tube = filter_input(INPUT_POST, 'right_tube');
        $row->right_tube_procedures = filter_input(INPUT_POST, 'right_tube_procedures');
        $row->left_tube = filter_input(INPUT_POST, 'left_tube');
        $row->left_tube_procedures = filter_input(INPUT_POST, 'left_tube_procedures');
        $row->right_ovary = filter_input(INPUT_POST, 'right_ovary');
        $row->right_ovary_procedures = filter_input(INPUT_POST, 'right_ovary_procedures');
        $row->left_ovary = filter_input(INPUT_POST, 'left_ovary');
        $row->left_ovary_procedures = filter_input(INPUT_POST, 'left_ovary_procedures');
        $row->uterosacrals = filter_input(INPUT_POST, 'uterosacrals');
        $row->uterosacrals_procedures = filter_input(INPUT_POST, 'uterosacrals_procedures');
        $row->peritoneum = filter_input(INPUT_POST, 'peritoneum');
        $row->peritoneum_procedures = filter_input(INPUT_POST, 'peritoneum_procedures');
        $row->recommendations = filter_input(INPUT_POST, 'recommendations');
        try {
            R::store($row);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $laparoscopic = R::findAll('laparoscopic');
        $this->smarty->assign('laparoscopic', $laparoscopic);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('laparoscopic/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $laparoscopic = R::load('laparoscopic', $id);
        $this->smarty->assign('laparoscopic', $laparoscopic);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('laparoscopic/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function render()
    {
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, 'template_id');
        $laparoscopic = R::getRow('select * from laparoscopic where id = ?', [$id]);

        echo json_encode($laparoscopic);
    }

    public function update()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('laparoscopic', $id);
        $row->template_name = filter_input(INPUT_POST, 'template_name');
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->uterus = filter_input(INPUT_POST, 'uterus');
        $row->uterus_procedures = filter_input(INPUT_POST, 'uterus_procedures');
        $row->right_tube = filter_input(INPUT_POST, 'right_tube');
        $row->right_tube_procedures = filter_input(INPUT_POST, 'right_tube_procedures');
        $row->left_tube = filter_input(INPUT_POST, 'left_tube');
        $row->left_tube_procedures = filter_input(INPUT_POST, 'left_tube_procedures');
        $row->right_ovary = filter_input(INPUT_POST, 'right_ovary');
        $row->right_ovary_procedures = filter_input(INPUT_POST, 'right_ovary_procedures');
        $row->left_ovary = filter_input(INPUT_POST, 'left_ovary');
        $row->left_ovary_procedures = filter_input(INPUT_POST, 'left_ovary_procedures');
        $row->uterosacrals = filter_input(INPUT_POST, 'uterosacrals');
        $row->uterosacrals_procedures = filter_input(INPUT_POST, 'uterosacrals_procedures');
        $row->peritoneum = filter_input(INPUT_POST, 'peritoneum');
        $row->peritoneum_procedures = filter_input(INPUT_POST, 'peritoneum_procedures');
        $row->recommendations = filter_input(INPUT_POST, 'recommendations');
        try {
            R::store($row);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('laparoscopic', 'id = ?', [$id]);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function __destruct()
    {
        R::close();
    }

}
