<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllName;
    public $shcontrollName;
    public $active;

    // it will run in everytime with
    // default requried

    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'operations_reserve';
        $this->shcontrollname = 'Operations Reserve';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);


# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'operations'; //controller name or tab name
        $active[1] = 'operations_reserve'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'show';
                break;
            case 'show':
                $active[2] = 'show';
                break;
            default :
                $active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

//here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class

    public function index() {

        //check login
        autho::checkautho($this->hosturl);

        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $operation_types = R::findAll('detections', ' del != 1 and for_operation = 1 ');
        $this->smarty->assign('operation_types', $operation_types);

        $this->smarty->assign('today_now', date('Y-m-d'));

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('operations_reserve/index.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function search() {

        //check login
        autho::checkautho($this->hosturl);


        // get vars if there are
        //$start_time = filter_input(INPUT_POST, 'start_time');
        //$end_time = filter_input(INPUT_POST, 'end_time');
        $operation_date = filter_input(INPUT_POST, 'operation_date');
        $operation_type_id = filter_input(INPUT_POST, 'operation_type_id');

        // get all rooms as search params
        if ($operation_date) {

            //day times
            $day_times = [
                '00:00', '00:30', '01:00', '01:30', '02:00', '02:30', '03:00', '03:30', '04:00', '04:30', '05:00', '05:30',
                '06:00', '06:30', '07:00', '07:30', '08:00', '08:30', '09:00', '09:30', '10:00', '10:30', '11:00', '11:30',
                '12:00', '12:30', '13:00', '13:30', '14:00', '14:30', '15:00', '15:30', '16:00', '16:30', '17:00', '17:30',
                '18:00', '18:30', '19:00', '19:30', '20:00', '20:30', '21:00', '21:30', '22:00', '22:30', '23:00', '23:30'];

            // get rooms from operation type
            $operation_type_info = R::findOne('detections', 'id = ?', [$operation_type_id]);

            /*  if ($operation_type_info) {

              $room_query = ' deleted != 1  ';
              // check if select all
              if ($operation_type_info->operations_rooms != -1) {
              $room_query .= ' AND id in (' . $operation_type_info->operations_rooms . ')';
              }

              # show rooms
              $operations_rooms = R::findAll('operations_rooms', $room_query);

              foreach ($operations_rooms as $operations_room) {
              $operation_times = [];
              foreach ($day_times as $day_time) {
              $saved_id = 0;
              // check if time in room start and end time
              if (strtotime($day_time) <= strtotime($operations_room->end_time) &&
              strtotime($day_time) >= strtotime($operations_room->start_time)) {


              // get reserve info if there
              $doctor_reserve = R::findOne('doctors_reserves', 'operations_room_id = ? and hour_text = ?
              and the_date = ?', [$operations_room->id, $day_time, $operation_date]);
              if ($doctor_reserve) {
              $color = 'red'; // not active , done
              $no = 1;
              $saved_id = $doctor_reserve->id;
              } else {
              $color = 'green';
              $no = 0; // active
              }
              } else {
              $color = 'grey';
              $no = 3; // disabled
              }

              $sin = [
              'hour_text' => $day_time,
              'status' => $no,
              'color' => $color,
              'saved_id' => $saved_id
              ];


              $operation_times[] = $sin;
              /*if (strtotime($day_time) <= strtotime($end_time) &&
              strtotime($day_time) >= strtotime($start_time)) {

              }*
              }
              $operations_room->times = $operation_times;
              }



              $this->smarty->assign('operations_rooms', $operations_rooms);
              } */


            // new controller options in royal
            $floors = R::getAll('SELECT DISTINCT floor_no FROM operations_rooms WHERE floor_no IS NOT NULL ORDER BY floor_no');
            $floors_arr = [];
            foreach ($floors as $floor) {
                $floor = (object) $floor;
                $o_rooms = R::findAll('operations_rooms', 'floor_no = ? and deleted = 0', [$floor->floor_no]);
                foreach ($o_rooms as $o_room) {
                    $doctor_reserve = R::findAll('doctors_reserves', 'operations_room_id = ? and the_date = ?', [$o_room->id, $operation_date]);
                    foreach ($doctor_reserve as $value) {
                        $doctor_info = R::findOne('awusers', 'user_id = ?', [$value->doctor_id]);
                        $value->doctor_name = $doctor_info->name;
                    }
                    $o_room->reserves = $doctor_reserve;
                }
                $floor->o_rooms = $o_rooms;

                $flor = R::load('floors', $floor->floor_no);
                $floor->floorName = $flor->name;

                $floors_arr[] = $floor;
            }
            $this->smarty->assign('floors_arr', $floors_arr);

            $r_floors = R::getAll('SELECT DISTINCT floor_no FROM residence_rooms WHERE floor_no IS NOT NULL ORDER BY floor_no');
            $r_floors_arr = [];
            foreach ($r_floors as $floor) {
                $floor = (object) $floor;
                $r_rooms = R::findAll('residence_rooms', 'floor_no = ? and deleted = 0', [$floor->floor_no]);
                foreach ($r_rooms as $r_room) {
                    $doctor_reserve = R::findAll('residence_reserves', 'residence_room_id = ? and the_date = ?', [$r_room->id, $operation_date]);
                    foreach ($doctor_reserve as $item) {
                        $doctor_info = R::findOne('awusers', 'user_id = ?', [$item->doctor_id]);
                        $item->doctor_name = $doctor_info->name;
                    }
                    $r_room->reserves = $doctor_reserve;
                }
                $floor->r_rooms = $r_rooms;

                $flor = R::load('floors', $floor->floor_no);
                $floor->floorName = $flor->name;

                $r_floors_arr[] = $floor;
            }
            $this->smarty->assign('r_floors_arr', $r_floors_arr);

            $role = R::findOne('awrole', ' id  = 13');
            $doctors = R::getAll('select * from awusers where deleted != 1 and  role_id in ( ' . $role->related_dr_depts . '  ) ');
            $this->smarty->assign('doctors', $doctors);
        }

        $this->smarty->display('operations_reserve/search_excel.html');
    }

    public function residence() {
        $last_hour = filter_input(INPUT_POST, 'last_hour');
        $hours_string = filter_input(INPUT_POST, 'hours_string');
        $operation_date = filter_input(INPUT_POST, 'operation_date');
        $operation_type = filter_input(INPUT_POST, 'operation_type');
        $data_room_id = filter_input(INPUT_POST, 'data_room_id');

        $operation_type_info = R::findOne('detections', 'id = ?', [$operation_type]);

        $this->smarty->assign('operation_date', $operation_date);
        $this->smarty->assign('hours_string', $hours_string);
        $this->smarty->assign('hours_arr', explode(',', $hours_string));
        $this->smarty->assign('operation_type', $operation_type_info);
        $this->smarty->assign('data_room_id', $data_room_id);

        $role = R::findOne('awrole', ' id  = 13');
        $doctors = R::getAll('select * from awusers where user_active = 1 and  role_id in ( ? ) ', [$role->related_dr_depts]);
        $this->smarty->assign('doctors', $doctors);

        $day_times = [
            '00:00', '01:00', '02:00', '03:00', '04:00', '05:00',
            '06:00', '07:00', '08:00', '09:00', '10:00', '11:00',
            '12:00', '13:00', '14:00', '15:00', '16:00', '17:00',
            '18:00', '19:00', '20:00', '21:00', '22:00', '23:00'];


        $residence_rooms = R::findAll('residence_rooms', 'deleted != 1');
        foreach ($residence_rooms as $residence_room) {
            $residence_times = [];
            foreach ($day_times as $day_time) {
                // check if hour is reserve
                $room_reserve = R::findOne('residence_reserves', 'hour_text = ? and the_date = ? and residence_room_id = ?', [$day_time, $operation_date, $residence_room->id]);
                if ($room_reserve) {
                    $no = 1;
                    $color = 'red';
                } else {
                    $no = 0;
                    $color = 'green';
                }

                $sin = [
                    'hour_text' => $day_time,
                    'status' => $no,
                    'color' => $color,
                ];
                if (strtotime($day_time) > strtotime($last_hour)) {
                    // check if hour is available
                    $residence_times[] = $sin;
                }
            }
            $residence_room->times = $residence_times;
        }
        $this->smarty->assign('residence_rooms', $residence_rooms);
        $this->smarty->assign('last_hour', $last_hour);

        $this->smarty->display('operations_reserve/residence.html');
    }

    public function reserve() {
        $operation_hours = filter_input(INPUT_POST, 'operation_hours');
        $operation_date = filter_input(INPUT_POST, 'operation_date');
        $residence_hours = filter_input(INPUT_POST, 'residence_hours');
        $doctor_id = filter_input(INPUT_POST, 'doctor_id');
        $operation_type = filter_input(INPUT_POST, 'operation_type');
        $operation_room_id = filter_input(INPUT_POST, 'operation_room_id');
        $residence_room_id = filter_input(INPUT_POST, 'residence_room_id');

        $operation_hours = substr($operation_hours, 0, -1);
        $residence_hours = substr($residence_hours, 0, -1);

        //R::debug('true');
        // add operation data
        $operation = R::xdispense('operations_main');
        $operation->create_date = date('Y-m-d');
        $operation->doctor_id = $doctor_id;
        $operation->the_date = $operation_date;
        $operation->operation_types_id = $operation_type;
        $operation->operation_hours = $operation_hours;
        $operation->operations_rooms_id = $operation_room_id;
        $operation->residence_hours = $residence_hours;
        $operation->residence_rooms_id = $residence_room_id;
        $operation_main_id = R::store($operation);

        // add operation room with hour with type and doctor
        $operation_hours = explode(',', $operation_hours);
        foreach ($operation_hours as $operation_hour) {
            if (empty($operation_hour)) {
                continue;
            }
            $doctors_reserve = R::xdispense('doctors_reserves');
            $doctors_reserve->doctor_id = $doctor_id;
            $doctors_reserve->operations_room_id = $operation_room_id;
            $doctors_reserve->hour_text = $operation_hour;
            $doctors_reserve->the_date = $operation_date;
            $doctors_reserve->operation_type = $operation_type;
            $doctors_reserve->operation_main_id = $operation_main_id;
            R::store($doctors_reserve);
        }

        // add residence room with hour with type and doctor
        $residence_hours = explode(',', $residence_hours);
        foreach ($residence_hours as $residence_hour) {
            if (empty($residence_hour)) {
                continue;
            }
            $residence_reserve = R::xdispense('residence_reserves');
            $residence_reserve->doctor_id = $doctor_id;
            $residence_reserve->residence_room_id = $residence_room_id;
            $residence_reserve->hour_text = $residence_hour;
            $residence_reserve->the_date = $operation_date;
            $residence_reserve->operation_type = $operation_type;
            $residence_reserve->operation_main_id = $operation_main_id;
            R::store($residence_reserve);
        }
    }

    public function removeRoom() {
        $remove_items = filter_input(INPUT_POST, 'remove_items');

        // cut and get items
        $rooms_items = explode(',', $remove_items);
        foreach ($rooms_items as $rooms_item) {
            if (empty($rooms_item)) {
                continue;
            }
            $item_details = explode(':', $rooms_item);

            // remove item
            $item_info = R::findOne($item_details[2], 'id = ?', [$item_details[1]]);
            R::trash($item_info);
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
