<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'sms_control';
        $this->shcontrollname = 'sms_control';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'programesetting'; //controller name or tab name
        $active[1] = 'sms_control'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("visits_common.php"); //general functions
//here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function show() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #################################################################### Heba : ## get all investigation category ##############################################################################
        $sms_control = R::findall('sms_control', 'deleted != 1 ');
        $this->smarty->assign('sms_control', $sms_control);

        $sms_setting = R::findOne('sms_control_setting');
        if (!(count($sms_setting) > 0 )) {
            $sms_setting = R::xdispense('sms_control_setting');
            R::store($sms_setting);
        }
        $this->smarty->assign('sms_setting', $sms_setting);
        ################################################################################################################################################################################
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('sms_control/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        try {
            $obj = R::load($tablename, $id);
            $obj->$colname = $value;
            R::store($obj);
            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");

        try {
            $table_obj = R::load($tableName, $id);
            $table_obj->deleted = 1;
            R::store($table_obj);

            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        ##################################################################
        $roles = R::findAll('awrole', 'visit_show = 1 ');
        $this->smarty->assign('roles', $roles);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('sms_control/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $fixed_link = filter_input(INPUT_POST, 'fixed_link');
        $en_link = filter_input(INPUT_POST, 'en_link');
        $message_type = filter_input(INPUT_POST, 'message_type');
        $message_place = filter_input(INPUT_POST, 'message_place');
        $sender_name = filter_input(INPUT_POST, 'sender_name');
        $message = filter_input(INPUT_POST, 'message');

        if (filter_input(INPUT_POST, 'for_depts_all') == 1) {
            $for_depts = -1;
        } else {
            $for_depts = '';
            $i = 1;
            foreach ($_POST['for_depts'] as $selectedOption) {

                if ($i != 1) {
                    $for_depts .= ' , ';
                }
                $for_depts .= $selectedOption;
                $i++;
            }
        }

        $sms_control = R::xdispense('sms_control');
        $sms_control->name = $name;
        $sms_control->fixed_link = $fixed_link;
        $sms_control->en_link = $en_link;
        $sms_control->message_type = $message_type;
        $sms_control->message_place = $message_place;
        $sms_control->sender_name = $sender_name;
        $sms_control->message = $message;
        $sms_control->for_depts = $for_depts;

        try {
            R::store($sms_control);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');

        //load all here
        $editElement = R::load('sms_control', $id);

        $roles = R::findAll('awrole', 'visit_show = 1 ');
        $this->smarty->assign('roles', $roles);

        #########################################
        $for_depts = array();

        if ($editElement->for_depts == -1) {
            $editElement->for_depts_all = 1;
        } else {
            $index_roles = explode(',', $editElement->for_depts);

            foreach ($index_roles as $value) {
                $value = trim($value);
                array_push($for_depts, $value);
            }
        }


        $this->smarty->assign('for_depts', $for_depts);
        $this->smarty->assign('editElement', $editElement);
        #########################################
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('sms_control/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        $name = filter_input(INPUT_POST, 'name');
        $fixed_link = filter_input(INPUT_POST, 'fixed_link');
        $en_link = filter_input(INPUT_POST, 'en_link');
        $message_type = filter_input(INPUT_POST, 'message_type');
        $message_place = filter_input(INPUT_POST, 'message_place');
        $sender_name = filter_input(INPUT_POST, 'sender_name');
        $message = filter_input(INPUT_POST, 'message');

        if (filter_input(INPUT_POST, 'for_depts_all') == 1) {
            $for_depts = -1;
        } else {
            $for_depts = '';
            $i = 1;
            foreach ($_POST['for_depts'] as $selectedOption) {

                if ($i != 1) {
                    $for_depts .= ' , ';
                }
                $for_depts .= $selectedOption;
                $i++;
            }
        }

        $sms_control = R::load('sms_control', $id);
        $sms_control->name = $name;
        $sms_control->fixed_link = $fixed_link;
        $sms_control->en_link = $en_link;
        $sms_control->message_type = $message_type;
        $sms_control->message_place = $message_place;
        $sms_control->sender_name = $sender_name;
        $sms_control->message = $message;
        $sms_control->for_depts = $for_depts;

        try {
            R::store($sms_control);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

// at the end of class call
    public function __destruct() {
        //echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }

}
