$(document).ready(function () {

    let host_url = $('#hosturl').val();
    let patient_id = $('#patientId').val();

    $('#laparoscopic_template').change(function () {
        let template_id = $(this).val();
        $.post(host_url + '/controllers/laparoscopic.php?ac=render', {template_id: template_id}, function (response) {
            $('input[name=entry]').val(response.entry);
            $('input[name=entry_procedures]').val(response.entry_procedures);
            $('input[name=uterus]').val(response.uterus);
            $('input[name=uterus_procedures]').val(response.uterus_procedures);
            $('input[name=right_tube]').val(response.right_tube);
            $('input[name=right_tube_procedures]').val(response.right_tube_procedures);
            $('input[name=left_tube]').val(response.left_tube);
            $('input[name=left_tube_procedures]').val(response.left_tube_procedures);
            $('input[name=right_ovary]').val(response.right_ovary);
            $('input[name=right_ovary_procedures]').val(response.right_ovary_procedures);
            $('input[name=left_ovary]').val(response.right_ovary);
            $('input[name=left_ovary_procedures]').val(response.right_ovary_procedures);
            $('input[name=uterosacrals]').val(response.uterosacrals);
            $('input[name=uterosacrals_procedures]').val(response.uterosacrals_procedures);
            $('input[name=peritoneum]').val(response.peritoneum);
            $('input[name=peritoneum_procedures]').val(response.peritoneum_procedures);
            $('textarea[name=recommendations]').val(response.recommendations);
        }, 'json');
    });

    $('#hystroscopic_template').change(function () {
        let template_id = $(this).val();
        $.post(host_url + '/controllers/hystroscopic.php?ac=render', {template_id: template_id}, function (response) {
            $('input[name=entry]').val(response.entry);
            $('input[name=entry_procedures]').val(response.entry_procedures);
            $('input[name=external_os]').val(response.external_os);
            $('input[name=external_os_procedures]').val(response.external_os_procedures);
            $('input[name=cervical_canal]').val(response.cervical_canal);
            $('input[name=cervical_canal_procedures]').val(response.cervical_canal_procedures);
            $('input[name=internal_os]').val(response.internal_os);
            $('input[name=internal_os_procedures]').val(response.internal_os_procedures);
            $('input[name=uterine_cavity]').val(response.uterine_cavity);
            $('input[name=uterine_cavity_procedures]').val(response.uterine_cavity_procedures);
            $('input[name=endometrium]').val(response.endometrium);
            $('input[name=endometrium_procedures]').val(response.endometrium_procedures);
            $('input[name=right_ostium]').val(response.right_ostium);
            $('input[name=right_ostium_procedures]').val(response.right_ostium_procedures);
            $('input[name=left_ostium]').val(response.left_ostium);
            $('input[name=left_ostium_procedures]').val(response.left_ostium_procedures);
            $('input[name=other]').val(response.other);
            $('input[name=other_procedures]').val(response.other_procedures);
            $('textarea[name=recommendations]').val(response.recommendations);
        }, 'json');
    });


    let oscopic_select = $(".oscopic-select");

    oscopic_select.select2({
        width: 'auto',
        allowClear: true,
        formatNoMatches: function (term) {
            var thisId = $(this).attr("id");
            var element_name = $(this).attr("name");
            var table_name = $(this).attr("data-select-tableName");
            return "<input class='form-control' id='newTableTerm' value='" + term + "'>" +
                "<a href='#' id='addNew' data-tableName='" + table_name + "' data-id='" + thisId + "' data-element-name='" + element_name + "' class='btn blue custombtnstyle'>ADD</a>"
        }
    }).parent().find('.select2-with-searchbox').on('click', '#addNew', function () {
        var name = $('#newTableTerm').val();
        var thisId = $(this).attr("data-id");
        var tableName = $(this).attr("data-tableName");
        var element_name = $(this).attr("data-element-name");
        $.post(hosturl + "/controllers/oscopic.php?ac=addToTable", {name: name, table_name: tableName}, function (data) {
            $('#' + thisId + ' > .delete-options-select').before('<option value="' + Number(data) + '" >' + name + '</option>');
            $('#' + thisId + '').select2('val', Number(data));
            $('.selectTable').select2('close');
            $('#' + element_name).trigger('change');
        });
    });

    oscopic_select.live('change', function () {
        var colName = "name";
        var tableName = $(this).attr("data-select-tableName");
        var attr = $(this).attr("id");
        console.log(attr);
        var filter_value = $(this).val();
        if (filter_value === 'delete-options-select') {
            $.post(hosturl + '/controllers/oscopic.php?ac=editModal', {tableName: tableName, colName: colName, filter_input: attr}, function (data) {
                console.log(data);
                $('#' + attr + '').select2("val", "");
                $("#async_data_container").html(data);
                $("#edit_model").modal('show');
            });
        }

    })

    $('#close-edit-model').on('change', function () {
        $("#async_data_container").html('');
    });

    $("#input-update-model").live('change', function () {
        var value = $(this).val();
        var id = $(this).attr("data-id");
        var tableName = $("#table_name_model").val();
        var colName = $("#col_name_model").val();
        var filter_input = $("#filter_input").val();

        if (id !== '') {
            $.post(hosturl + '/controllers/oscopic.php?ac=updateModal', {tableName: tableName, colName: colName, id: id, value: value}, function () {
                $("#" + filter_input + " option[value='" + id + "']").text(value);
                $('#' + filter_input).select2('val', id);
            });
        }
    });


    $('.remove-element-model').live('click', function () {
        var id = $(this).attr('data-id');
        var filter_input = $("#filter_input").val();
        var table_name_model = $("#table_name_model").val();
        var tr = $(this).parent();
        bootbox.dialog({
            message: "Do you want to delete this item?",
            title: "Delete confirmation",
            buttons: {
                danger: {
                    label: "Cancel",
                    className: "btn-primary"
                },
                main: {
                    label: "Delete",
                    className: "btn-danger",
                    callback: function () {
                        $.post(hosturl + '/controllers/oscopic.php?ac=deleteModelItem', {id: id, tableName: table_name_model}, function (res) {
                            if (Number(res) === 1) {
                                tr.parent().remove();
                                $("#" + filter_input + " option[value='" + id + "']").remove();
                            } else {
                                alert("!!!!!!!!!!!!! some thing wrong here");
                            }
                        });
                    }
                }
            }
        }).find('.modal-content').addClass('modal-sm');
    });
});