<div class="modal-body text-center" style="padding: 20px 0px 0px;">
    <div class="row">
        <input type="hidden" value="{$visit->id}" name="id">
        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Doctor</label>
                <div class="col-md-9">
                    <select class="form-control select2edit" disabled required="required" name="doctor_id" data-placeholder="Select...">
                        <option></option>
                        {foreach $doctors as $doctor}
                            <option value="{$doctor.user_id}" {if $visit->doctor_id eq $doctor.user_id} selected {/if}>{$doctor.name}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Services</label>
                <div class="col-md-9">
                    <select class="form-control select2edit" disabled required="required" id="service_ids" multiple="multiple" data-placeholder="Select...">
                        <option></option>
                        {foreach $operation_types as $operation_type}
                            <option value="{$operation_type->id}" {foreach $services as $service}{if $operation_type->id eq $service} selected {/if}{/foreach}>{$operation_type->title}</option>
                        {/foreach}
                    </select>
                    <input type="hidden" name="service_ids_hide" value="{implode(',',$services)}">
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">User</label>
                <div class="col-md-9">
                    <select class="form-control select2edit" disabled required="required" name="user_id" data-placeholder="Select...">
                        <option></option>
                        {foreach $users as $user}
                            <option value="{$user.user_id}" {if $visit->user_id eq $user.user_id} selected {/if}>{$user.name}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Branch</label>
                <div class="col-md-9">
                    <select class="form-control select2edit" disabled required="required" name="branch_id" data-placeholder="Select...">
                        <option></option>
                        {foreach $branches as $branch}
                            <option value="{$branch->id}" {if $visit->branch_id eq $branch->id} selected {/if}>{$branch->name}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Status</label>
                <div class="col-md-9">
                    <select class="form-control select2edit" required="required" name="status" data-placeholder="Select...">
                        <option></option>
                        {foreach $status as $single}
                            <option value="{$single.id}" {if $visit->status eq $single.id} selected="selected" {/if} {if $single.id < 4} disabled="disabled" {/if}>{$single.name}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Date</label>
                <div class="col-md-9">
                    <input type="text" class="form-control notPop datepicker" disabled name="date" id="date" value="{$visit->date|date_format:"%Y/%m/%d"}" required="required"/>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Start time</label>
                <div class="col-md-9">
                    <input type="text" class="form-control notPop timepicker timepicker-24" disabled name="start_time" id="start_time" value="{$visit->start_time}" required="required"/>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">End time</label>
                <div class="col-md-9">
                    <input type="text" class="form-control notPop timepicker timepicker-24" disabled name="end_time" id="end_time" value="{$visit->end_time}" required="required"/>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group">
                <label class="col-md-3 txtl">Room</label>
                <div class="col-md-9">
                    <select class="form-control select2edit" disabled required="required" name="room_id" id="room_id" data-placeholder="Select...">
                        <option></option>
                        {foreach $operation_rooms as $room}
                            <option value="{$room.id}" {if $visit->room_id eq $room.id} selected {/if}>{$room.name}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>

        <div class="col-md-6" style="padding: 10px 15px;">
            <div class="form-group" id="patient_input">
                <label class="col-md-3 txtl">Patient</label>
                <div class="col-md-9">
                    <input type="text" class="form-control" disabled name="patient_id" required="required" value="{$visit->patient_id}" id="search_patient_op_edit" data-placeholder="Select..."/>
                </div>
            </div>
        </div>


        <div class="clearfix"></div>
        <hr/>

        <h4>Paid & Pulse Amount</h4>

        {foreach $visit_services as $single}
            <h5>{$single->service->title}</h5>
            <div class="col-md-6" style="padding: 10px 15px;">
                <div class="form-group">
                    <label class="col-md-3 txtl">Paid amount</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control notPop" name="paid_amount_{$single->id}" number="true" value="{$single->paid_amount}"/>
                    </div>
                </div>
            </div>
            <div class="col-md-6" style="padding: 10px 15px;">
                <div class="form-group">
                    <label class="col-md-3 txtl">Pulse Number</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control notPop" name="pulse_no_{$single->id}" digits="true" value="{$single->pulse_no}"/>
                    </div>
                </div>
            </div>
        {/foreach}

    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    <button type="button" id="update_btn" class="btn btn-primary">Save changes</button>
</div>