<div class="page-content-wrapper">
    <div class="page-content all">
        <div class="row">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->


                <div class="portlet box blue">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-cogs"></i>Vote Report details for : {$user_info->name}
                        </div>
                        <div class="actions">
                            <a class="btn btn-default btn-sm" href="{$hosturl}/controllers/{$controllname}.php?ac=show">
                                <i class="fa fa-eye"></i> Show </a>
                            <a class="btn btn-default btn-sm" href="{$hosturl}/controllers/{$controllname}.php?ac=report">
                                <i class="fa fa-area-chart"></i> Report </a>
                        </div>

                    </div>
                    <div class="portlet-body" style="padding: 15px;">
                        <input id="patientId" type="hidden" value="{$patientId}">

                        <h4>General statistics</h4>
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>Count No.</th>
                                <th>Question No.</th>
                                <th>Vote no.</th>
                                {foreach $count_answer_text as $answer}
                                    <th>{$answer.answer_text}</th>
                                {/foreach}
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="odd gradeX ">
                                <td>{$count_votes}</td>
                                <td>{$count_question[0]}</td>
                                <td>{$count_answer[0]}</td>
                                {foreach $count_answer_text as $answer}
                                    <td>{$answer.count_answer} ({round(($answer.count_answer/$count_answer[0])*100)}%)</td>
                                {/foreach}
                            </tr>
                            </tbody>

                        </table>

                        {foreach $votes as $vote}
                            <h4>Vote Information</h4>
                            <table class="table table-striped table-bordered table-hover">
                                <tr>
                                    <th>Vote ID</th>
                                    {*<th>Client name</th>*}
                                    <th>Client phone</th>
                                    <th>vote date</th>
                                </tr>
                                <tr>
                                    <td>{$vote->id}</td>
                                    {*<td>{$vote->voter_name}</td>*}
                                    <td>{if $vote->is_contact eq 'true'}<i class="fa fa-check-circle" style="font-size: 17px;color: forestgreen"></i>{/if} {$vote->voter_phone}</td>
                                    <td>{$vote->created_at|date_format:"%d/%m/%Y %H:%M %p"}</td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <label style="float: left;margin-bottom: 5px;">
                                            <input type="checkbox" class="client_vote_contact" data-vote-id="{$vote->id}" value="1" {if $vote->is_contact eq 'true'}checked{/if}>
                                            تم التواصل مع المريض
                                        </label>
                                        <br>
                                        <textarea data-vote-id="{$vote->id}" placeholder="Client comment ..." class="form-control client_vote_reply" rows="2">{$vote->reply}</textarea>
                                    </td>
                                </tr>
                            </table>
                            <h6>Vote Details</h6>
                            <table class="table table-striped table-bordered table-hover">
                                <tr>
                                    <th>Question</th>
                                    <th>Answer</th>
                                </tr>
                                {foreach $vote->answers as $vote_detail}
                                    <tr>
                                        <td>{$vote_detail->question->question}</td>
                                        <td>{$vote_detail->answer_text}</td>
                                    </tr>
                                {/foreach}
                            </table>
                            <hr>
                        {/foreach}
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

